<?php

// $Id: executesqlfile.php,v 1.2 2001/03/16 04:32:31 nick Exp $
// $Log: executesqlfile.php,v $
// Revision 1.2  2001/03/16 04:32:31  nick
// Changed file suffices to .php rather than .php4
//
// Revision 1.1  2001/02/20 04:35:17  nick
// Initial revision
//

require ("config.php");
require ($CONFIG_PATH . "general_config.php");
require ($INCLUDE_DIRECTORY . "common.php");

/*
Copyright  2001 Nick Gammon.

  Author: Nick Gammon <nick@gammon.com.au>
  Web:    http://www.gammon.com.au/
  Date:   February 2001

  This program is free software; you can redistribute it and/or modify 
  it under the terms of the GNU General Public License as published by 
  the Free Software Foundation; either version 2 of the License, 
  or (at your option) any later version. 

  This program is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
  See the GNU General Public License for more details. 

  You should have received a copy of the GNU General Public License 
  along with this program; if not, write to 

  The Free Software Foundation, Inc., 
  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


  The Free Software Foundation maintains a web page at: http://www.fsf.org

  See the file gpl.txt for the full GNU General Public License.

*/

Init ("Execute SQL file"); 

// check we can do it
Permission ("executesql");

?>

<h1>Execute SQL commands in a file</h1>

<p>Note: all commands must be on a single line.</p>


<form METHOD="post" ACTION="<?php echo $PHP_SELF;?>"> 
 <p>File name to execute: &nbsp;
 <input type=text name=filename value="<?php echo "$filename"; ?>" size=25 maxlength=55>
 </p>
 <p><input Type=submit Value="Execute"> </p>
<?php FormSession (); ?>
</form> 

<hr>

<?php

$fd = 0;
$totalrows = 0;
$linecount = 0;
$statements = 0;

function Summary ()
  {
  global $totalrows, $linecount, $statements;

  echo "<p><b>$totalrows rows have been affected.</b></p>\n";
  echo "<p><b>$linecount lines have been read.</b></p>\n";
  echo "<p><b>$statements SQL statements have been executed.</b></p>\n";
  
  } // end of Summary
  
function ExecuteProblem ($why)
  {
  global $fd;
  
  echo "<h3>Problem executing SQL file</h3>\n<p>";
  echo ($why);
  // close file if open
  if ($fd > 0)
    fclose ($fd);
  Summary ();
  MessageTail (true); 
  die ();
  } // end of ExecuteProblem
 
/*

Web page to execute a file containing SQL statements 

*/

// no file name yet? do nothing.
if (empty ($filename))
  ExecuteProblem ("No file name specified.");
    
$fd = @fopen ($filename, "r") or ExecuteProblem ("Cannot open file '$filename'");  
 
OpenDatabase ();

while (!feof ($fd))
  {
  $line = trim (fgets ($fd, 100000));
  $linecount++;   // count lines we have processed
  
  if (empty ($line))
    continue;   // ignore blank lines

  // ignore comments
  if ($line [0] == "#")
    continue;

  // remove trailing semicolon
  if ($line [strlen ($line) - 1] == ";")
     $line [strlen ($line) - 1] = " ";
   
  $result = mysql_query ($line) 
          or die ("SQL statement failed: </font><p><code>$line</code></p> "
                  . "<FONT FACE=\"Arial, Helvetica, Geneva\" SIZE=-1>"
                  . "<p>Reason: </p>" 
                  . "<b>" . mysql_error () . "</b>");

  $statements++;    // count statements executed
  $totalrows += mysql_affected_rows ();   // count affected rows
  } // end of reading file

fclose ($fd);

Summary ();

MessageTail (false); 

?>
