<?php

// $Id: bbshowbio.php,v 1.15 2001/04/05 00:12:48 nick Exp $
// $Log: bbshowbio.php,v $
// Revision 1.15  2001/04/05 00:12:48  nick
// Fixed problems with UTC code.
//
// Revision 1.14  2001/04/04 00:54:59  nick
// Added UTC time handling.
//
// Revision 1.13  2001/03/16 04:31:03  nick
// Changed file suffices to .php rather than .php4
//
// Revision 1.12  2001/03/13 09:10:55  nick
// Minor fixes
//
// Revision 1.11  2001/03/09 10:32:55  nick
// Added pagination of posts
//
// Revision 1.10  2001/03/08 22:56:46  nick
// More enhancements
//
// Revision 1.9  2001/03/07 03:21:34  nick
// Changes for section moderators, adding topics, etc.
//
// Revision 1.8  2001/03/04 22:49:12  nick
// Further bug fixes following production testing
//
// Revision 1.7  2001/02/27 21:45:26  nick
// Improvements made during testing
//
// Revision 1.6  2001/02/22 23:27:29  nick
// More enhancements
//
// Revision 1.5  2001/02/21 23:43:08  nick
// Added copyright notice, new config stuff
//
// Revision 1.4  2001/02/11 21:07:49  nick
// More changes
//
// Revision 1.3  2001/02/08 21:15:27  nick
// More changes
//
// Revision 1.2  2001/02/07 21:20:50  nick
// Changes after beta test
//
// Revision 1.1  2001/02/03 21:21:18  nick
// Initial revision
//

/*

Copyright  2001 Nick Gammon.

  Author: Nick Gammon <nick@gammon.com.au>
  Web:    http://www.gammon.com.au/
  Date:   February 2001

  This program is free software; you can redistribute it and/or modify 
  it under the terms of the GNU General Public License as published by 
  the Free Software Foundation; either version 2 of the License, 
  or (at your option) any later version. 

  This program is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
  See the GNU General Public License for more details. 

  You should have received a copy of the GNU General Public License 
  along with this program; if not, write to 

  The Free Software Foundation, Inc., 
  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


  The Free Software Foundation maintains a web page at: http://www.fsf.org

  See the file gpl.txt for the full GNU General Public License.

*/

require ("config.php");
require ($CONFIG_PATH . "general_config.php");
require ($INCLUDE_DIRECTORY . "common.php");

Init ("Forum user profile", "forum, user, profile"); 

$forum_name = $control ['forum_name'];

// ---------------- start of main section -------------------

// DEBUG

// DebugVars ();

// validate input so we don't get sneaky SQL problems

CheckField ("message", $bbpost_id);
CheckField ("subject", $bbsubject_id);
CheckField ("topic", $bbtopic_id);
CheckField ("section", $bbsection_id);
CheckField ("user", $bbuser_id);

if (empty ($bbuser_id))   // nothing? oops
  Problem ("No user id specified");

if ($action == "unsubscribe" || $action == "unsubscribeall")
  {

  if (!$foruminfo)
    Problem ("You have not logged in");
  
  if ($foruminfo ['bbuser_id'] != $bbuser_id && !$foruminfo ['admin'])
    Problem ("You cannot unsubscribe another user");

  if ($action == "unsubscribe")
    {
    if ($bbsubject_id)
      mysql_query ( "DELETE FROM bbnotify_subject "
                  . "WHERE bbuser_id = $bbuser_id AND bbsubject_id = $bbsubject_id ");
    else if ($bbtopic_id)
      mysql_query ( "DELETE FROM bbnotify_topic "
                  . "WHERE bbuser_id = $bbuser_id AND bbtopic_id = $bbtopic_id ");
    }  // end of unsubscribe single
  else
    {
    mysql_query ( "DELETE FROM bbnotify_subject WHERE bbuser_id = $bbuser_id");
    mysql_query ( "DELETE FROM bbnotify_topic   WHERE bbuser_id = $bbuser_id");
    } // end of unsubscribe all
  
  } // end of unsubscribe
     
//-------------
// lookup user
//-------------

$dateformat = $control ['dateformat'];
$tz = $foruminfo ['time_zone'];
if (!$tz)
  $tz = 0;  // not logged in? Assume UTC


$query = "SELECT *, "
       . "DATE_FORMAT(DATE_ADD(date_registered, INTERVAL $tz HOUR), '$dateformat') AS formatted_date, "
       . "(TO_DAYS(CURDATE()) - TO_DAYS(birth_date)) / 365.25 AS age "
       . "FROM bbuser "
       . "WHERE bbuser_id = $bbuser_id "; 
                      
$result = mysql_query ($query) 
    or Problem ("Select failed: " . mysql_error ());
  
if (!($row = mysql_fetch_array ($result)))
    Problem ("User number $bbuser_id is not on file.");

 
$username = $row ["username"];
$email = htmlentities ($row ["email"]);
$home_page = htmlentities ($row ["home_page"]);

$table ['username'] = $row ["username"];
if ($row ['country'])
  $table ['country'] = $row ["country"];

$age = floor ($row ["age"]);

// rule out stupid ages (people being silly)
if ($age >= 5 && $age <= 100)
  $table ['age'] = $age;

$table ['date_registered'] = $row ["formatted_date"];
$table ['bio'] = $row ["bio"];
$table ['count_posts'] = $row ["count_posts"];

if ($row ['icq'])
  $table ['icq'] = $row ["icq"];
if ($home_page)
  {
  if (strtolower (substr ($home_page, 0, 7)) != "http://")
    $home_page = "http://" . $home_page;
    
  $table ['home_page'] = "<a href = \"$home_page\">$home_page</a>";
  }
  
// they can view their *own* email address  

if ($row ['show_email'] || ($bbuser_id == $foruminfo ['bbuser_id']))
  {
  $table ['email'] = "<a href = \"mailto:$email\">$email</a>";
  if (!$row ['show_email'])   // private?
    $table ['email'] .= "&nbsp;<i>(private)</i>";
  if ($row ['bounced'])   // uh oh, we can't mail to them
    $table ['email'] .= "&nbsp;<b>(bounced)</b>";
  }

echo "<h1>" . htmlentities ($forum_name) . "</h1>\n";

?>

<h2>User profile for <?php echo htmlentities ($username) ?></h2>

<hr>

<?php

// warn them first if their mail has bounced

if ($bbuser_id == $foruminfo ['bbuser_id'])
  if ($row ['bounced'])   // uh oh, we can't mail to them
    echo "<p><b>Warning:</b> Mail sent to you has bounced. "
       . "Mail notifications are disabled.</p>";

ShowTable ($table,  // the data
          array (     // table parameters
                'LH' => 'valign=top bgcolor="#ADD8E6" align=right',
                'RH' => 'bgcolor="#FAF0E6" align=left'
                ),
          array (     // specials
                'username'     => array ('username' => true,  // want this in bold
                                         'description' => 'Name:'),  
                'email' => array ('description' => 'Email:',
                                  'html' => true), 
                'country' => array ('description' => 'Country:'), 
                'date_registered' => array ('description' => 'On since:'), 
                'icq' => array ('description' => 'ICQ number:'), 
                'home_page' => array ('description' => 'Home page:',
                                      'html' => true), 
                'bio'     => array ('breaks' => true,     // want line breaks
                                    'description' => 'Biography:'),   
                'count_posts' => array ('description' => 'Posts:'), 
                'age' => array ('description' => 'Age:'), 
                )
          );
  

mysql_free_result ($result);

// send mail to them?
// to do so:
// 1. they must permit mail (or disclose their email address) AND
// 2. we must permit a reply (ie. allow mail or disclose OUR email address) AND
// 3. we don't send mail to ourselves AND
// 4. email to them hasn't bounced AND
// 5. email to use hasn't bounced AND
// 6. sending mail is permitted in the control table

if ($control ['allow_messages']) 
  if ((($row ['show_email'] || $row ['allow_mail']) &&    // they permit mail
      ($foruminfo ['show_email'] || $foruminfo ['allow_mail']) &&   // we permit mail
      ($bbuser_id != $foruminfo ['bbuser_id']) &&     // not to ourselves
      !$row ['bounced'] &&       // not receiver bounced
      !$foruminfo ['bounced']    // not sender bounced
      )  
      || $foruminfo ['admin']   // admins can do it anyway  
     )
    {
    echo "<p>"; 
    hLink ("Send an email to " . htmlentities ($row ['username']), 
           "bbsendmail.php", "bbuser_id=$bbuser_id", false);
    echo "</p>";
    } // end of letting them edit it

if ($bbuser_id == $foruminfo ['bbuser_id'])
  {
  echo "<p>"; 
  hLink ("Edit my profile", "bbuseredit.php", "action=amend&bbuser_id=$bbuser_id", true);
  echo "</p>";
  } // end of letting them edit it
else if ($foruminfo ['admin'])
  {
  echo "<p>"; 
  hLink ("Edit their profile", "bbuseredit.php", "action=amend&bbuser_id=$bbuser_id", true);
  echo "</p>";
  } // end of letting them edit it
    
  
// show recent posts

$datetimeformat = $control ['datetimeformat'];
$tz = $foruminfo ['time_zone'];
if (!$tz)
  $tz = 0;  // not logged in? Assume UTC
 
// limit of counts from the control file
    
$LIMIT = $control ['recent_posts_count'];
if (!$LIMIT)
  $LIMIT = 20;
  
$query = "SELECT bbsubject.bbsubject_id,  "
       . "  CONCAT(section_name, ': ', topic_name, ': ', subject_name) AS fullname, "
       . "  DATE_FORMAT(DATE_ADD(bbsubject.last_post_date, INTERVAL $tz HOUR), '$datetimeformat') AS formatted_date "
       . "FROM bbpost, bbsubject, bbtopic, bbsection "
       . "WHERE bbuser_id = $bbuser_id "
       . "  AND bbsection.bbsection_id = bbtopic.bbsection_id  "
       . "  AND bbtopic.bbtopic_id = bbsubject.bbtopic_id "
       . "  AND bbsubject.bbsubject_id = bbpost.bbsubject_id "
       . "GROUP BY bbsubject_id "
       . "ORDER BY post_date DESC, subject_name "
       . "LIMIT $LIMIT";


echo "<hr><h4>Recent posts</h4>\n";

$result = mysql_query ($query) 
  or Problem ("Select failed: " . mysql_error ());
$count = mysql_num_rows ($result);

bList (); // start list

while ($row = mysql_fetch_array ($result))
  {

  LI ();
  hLink (htmlspecialchars ($row ['fullname']), 
          $control ['forum_url'] . '/bbshowpost.php', 
          "bbsubject_id=" . $row ['bbsubject_id']);
  echo "&nbsp;<font size=1>" 
      . htmlentities ($row ['formatted_date'])          
     . "</font>\n";

  } // end of reading each row
eList ();   // end of list

if ($count >= $LIMIT)
  echo "<p>List limited to $count items.</p>";
else if (!$count)
  echo "<p>(none)</p>\n";

// show subscriptions
  
if ($foruminfo ['bbuser_id'] == $bbuser_id || $foruminfo ['admin'])
  {  
  // show topic subscriptions
  
  $result = mysql_query ("SELECT bbtopic.bbtopic_id, "
                       . "  concat(section_name, ': ', topic_name) "
                       . "AS description "
                       . "FROM bbtopic, bbsection, bbnotify_topic "
                       . "WHERE bbsection.bbsection_id = bbtopic.bbsection_id  "
                       . " AND  bbnotify_topic.bbtopic_id = bbtopic.bbtopic_id  "
                       . " AND  bbnotify_topic.bbuser_id = $bbuser_id  "
                       . "ORDER BY section_name, topic_name") 
    or Problem ("Select of topics failed: " . mysql_error ());
    
  if ($count1 = mysql_num_rows ($result))
    {
    echo "<hr><h4>Topics subscribed to</h4><ul>\n";
    
    while ($row = mysql_fetch_array ($result))
      {
      $bbtopic_id = $row ['bbtopic_id'];
      LI ();
      hLink (htmlentities ($row ['description']), 
             $control ['forum_url'] . '/bbshowpost.php', 
             "bbtopic_id=$bbtopic_id");
      
      echo "&nbsp;-&nbsp;";
      hLink ("Unsubscribe", 
            $PHP_SELF, 
            "action=unsubscribe&bbtopic_id=$bbtopic_id&bbuser_id=$bbuser_id");
      } // end of topic loop
      
    echo "</ul>";
    
    }   // end of having some rows
     
  mysql_free_result ($result);

  // show subject subscriptions
  
  $result = mysql_query ("SELECT bbsubject.bbsubject_id, "
                       . "  concat(section_name, ': ', topic_name, ': ', subject_name) "
                       . "AS description "
                       . "FROM bbtopic, bbsection, bbsubject, bbnotify_subject "
                       . "WHERE bbsection.bbsection_id = bbtopic.bbsection_id  "
                       . " AND  bbtopic.bbtopic_id = bbsubject.bbtopic_id  "
                       . " AND  bbnotify_subject.bbsubject_id = bbsubject.bbsubject_id  "
                       . " AND  bbnotify_subject.bbuser_id = $bbuser_id  "
                       . "ORDER BY section_name, topic_name, subject_name") 
    or Problem ("Select of subjects failed: " . mysql_error ());
    
  if ($count2 = mysql_num_rows ($result))
    {
    echo "<hr><h4>Subjects subscribed to</h4><ul>\n";
    
    while ($row = mysql_fetch_array ($result))
      {
      $bbsubject_id = $row ['bbsubject_id'];
      LI (); 
      hLink (htmlentities ($row ['description']), 
             $control ['forum_url'] . '/bbshowpost.php', 
             "bbsubject_id=$bbsubject_id");      
      echo "&nbsp;-&nbsp;";
      hLink ("Unsubscribe", 
             $PHP_SELF, 
             "action=unsubscribe&bbsubject_id=$bbsubject_id&bbuser_id=$bbuser_id");
      } // end of topic loop
      
    echo "</ul>";
    
    }   // end of having some rows
     
  mysql_free_result ($result);

  // let them unsubscribe from them all
  if ($count1 + $count2)
    {
    echo "<p>";
    hLink ("Cancel ALL subscriptions", 
           $PHP_SELF, 
           "action=unsubscribeall&bbuser_id=$bbuser_id");
    echo "</p>";
    }
  } // end of doing ourself, or being an admin
  
echo "<hr><p>\n";
hLink ("View list of registered users", "bbuserlist.php", "", false);
echo "</p><p>";
hLink ("Back to $forum_name", "bbshowpost.php");
echo "</p>";
        
?>

<hr>

<?php MessageTail (); ?>