<?php

// $Id: bbuserlist.php,v 1.10 2001/04/06 06:26:15 nick Exp nick $
// $Log: bbuserlist.php,v $
// Revision 1.10  2001/04/06 06:26:15  nick
// Added user pagination, fixed icon for next and previous.
//
// Revision 1.9  2001/04/05 00:12:48  nick
// Fixed problems with UTC code.
//
// Revision 1.8  2001/04/04 00:54:59  nick
// Added UTC time handling.
//
// Revision 1.7  2001/03/16 04:31:03  nick
// Changed file suffices to .php rather than .php4
//
// Revision 1.6  2001/03/09 10:32:55  nick
// Added pagination of posts
//
// Revision 1.5  2001/03/07 03:21:34  nick
// Changes for section moderators, adding topics, etc.
//
// Revision 1.4  2001/03/04 22:49:12  nick
// Further bug fixes following production testing
//
// Revision 1.3  2001/02/27 21:45:26  nick
// Improvements made during testing
//
// Revision 1.2  2001/02/21 23:42:38  nick
// Added copyright notice, new config stuff
//
// Revision 1.1  2001/02/08 21:16:09  nick
// Initial revision
//

/*

Copyright  2001 Nick Gammon.

  Author: Nick Gammon <nick@gammon.com.au>
  Web:    http://www.gammon.com.au/
  Date:   February 2001

  This program is free software; you can redistribute it and/or modify 
  it under the terms of the GNU General Public License as published by 
  the Free Software Foundation; either version 2 of the License, 
  or (at your option) any later version. 

  This program is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
  See the GNU General Public License for more details. 

  You should have received a copy of the GNU General Public License 
  along with this program; if not, write to 

  The Free Software Foundation, Inc., 
  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


  The Free Software Foundation maintains a web page at: http://www.fsf.org

  See the file gpl.txt for the full GNU General Public License.

*/

require ("config.php");
require ($CONFIG_PATH . "general_config.php");
require ($INCLUDE_DIRECTORY . "common.php");

Init ("Forum user list", "forum, user, list"); 

$forum_name = $control ['forum_name'];
  
CheckField ("page", $page);
  
// ---------------- start of main section -------------------

echo "<h1>" . htmlentities ($forum_name) . "</h1>\n";

// ---------------- ALL users -------------------

echo "<h2>Forum users</h2>";

echo "<p>These are the people who have registered to use the forum.</p>";

$dateformat = $control ['dateformat'];
$tz = $foruminfo ['time_zone'];
if (!$tz)
  $tz = 0;  // not logged in? Assume UTC

// select non-blocked users
$query = "SELECT *, "
       . "DATE_FORMAT(DATE_ADD(date_registered, INTERVAL $tz HOUR), '$dateformat') AS formatted_date, "
       . "DATE_FORMAT(DATE_ADD(last_post_date, INTERVAL $tz HOUR), '$dateformat') AS formatted_last_post_date "       
       . "FROM bbuser "
       . "WHERE (blocked IS NULL OR blocked = 0) "
       . "ORDER BY username";
                      
$result = mysql_query ($query) 
    or Problem ("Select of users failed: " . mysql_error ());

$users_per_page = $control ['users_per_page'];
// don't divide by zero, or have one user per page :)
if ($users_per_page < 5)
  $users_per_page = 20;

$count_users = mysql_num_rows ($result);


$user_pages = floor ((($count_users - 1) / $users_per_page) + 1);

// make sure requested page is in range

if ($page < 1)
  $page = 1;  // too small, make 1
  
if ($page > $user_pages)
  $page = $user_pages;   // too large, make maximum

$first_user = (($page - 1) * $users_per_page) + 1;
$last_user = $first_user + $users_per_page - 1;

// show them what pages there are

if ($user_pages > 1)
  {
  echo "<p align=right><b>Pages: ";
  for ($i = 1; $i <= $user_pages; $i++)
    {
    if ($i == $page)
      echo "$i&nbsp;";
    else
      {
      hLink ("$i", $PHP_SELF, "page=$i", false);
      echo "&nbsp;";
      }       
    } // end of doing each page
    
  echo "</b></p>\n";                
  }

echo "<table border=1 cellpadding=5 width=\"100%\">\n";


// column names

bRow ("lightblue");
  tHead ('Name');
  tHead ('Email');
  tHead ('Country');
  tHead ('Date joined');
  tHead ('Posts');
  tHead ('Last post');
eRow ();
  
$item = 0;      
while ($row = mysql_fetch_array ($result))
  {
  if (++$item < $first_user)
    continue;   // skip ones from previous pages
  if ($item > $last_user)
    break;      // have come to the end
    
  // row data
  shLink ($usernamelink, htmlentities ($row ['username']), 
          "bbshowbio.php", 
          "bbuser_id=" . $row ['bbuser_id']);
  if ($row ['show_email'])
      $emaillink = "<a href=\"mailto:"
                . htmlentities ($row ["email"])
                . "\">"
                . htmlentities ($row ["email"])
                . "</a>";
  else
    $emaillink = "-";
    
  $country = $row ['country'];
  
  if (!$country)
    $country = "-";
    
  bRow ("azure");
    tDataH ($usernamelink);
    tDataH ($emaillink);
    tData ($country);
    tDataH ("<font size=1>" . $row ['formatted_date'] . "</font>");
    tData ($row ['count_posts'], -1, "right");
    tDataH ("<font size=1>" . $row ['formatted_last_post_date'] . "</font>");
  eRow ();
  } // end of loop


eTable ();
 
echo "<p></p>"; 

// show all pages again

if ($user_pages > 1)
  {
  echo "<p><b>This is page $page of $user_pages pages: ";
  if ($page > 1)
    {
    echo "&nbsp;";
    hLink ("<img src=\"/images/thin_prev.gif\" alt=\"[Previous page]\" "
         . "align=bottom border=0 width=73 height=18>", 
           $PHP_SELF, "page=" . ($page - 1), false);
    echo "&nbsp;";
    }
  for ($i = 1; $i <= $user_pages; $i++)
    {
    if ($i == $page)
      echo "$i&nbsp;";
    else
      {
      hLink ("$i", $PHP_SELF, "page=$i", false);
      echo "&nbsp;";
      }       
    } // end of doing each page
  if ($page < $user_pages)
      hLink ("<img src=\"/images/thin_next.gif\" alt=\"[Next page]\" "
           . "align=bottom border=0 width=73 height=18>", 
             $PHP_SELF, "page=" . ($page + 1), false);
    
  echo "</b></p>\n";   
  
  mysql_data_seek ($result, 0); // back to start of result set

  // now show which page you might usefully go to, to find a particular person
  
  
  echo "<hr><h3>Index of user names</h3>\n";
  
  bTable ();
    
  // column names
  
  bRow ("lightblue");
    tHead ('Page');
    tHead ('First on page');
    tHead ('Last on page');
  eRow ();

  $item = 0;      
  $page = 0;
  while ($row = mysql_fetch_array ($result))
    {
    $item++;
    
    if ($item % $users_per_page == 1)
      $firstname = $row ['username'];
      
    if ($item % $users_per_page == 0 || $item == $count_users)
      {
      $lastname = $row ['username'];
      $page++;
      
      shLink ($pagelink, "$page", $PHP_SELF, "page=$page", false);
    
      bRow ("azure");
        tDataH ($pagelink);
        tData ($firstname);
        tData ($lastname);
      eRow ();
      
      } // end of batch of users_per_page users
    
    } // end of loop

  eTable ();
                
  }

mysql_free_result ($result);

echo "<p><b>Total of $count_users forum users.</b></p>";

echo "<hr>\n";

// ---------------- admins -------------------

echo "<h2>Forum administrators</h2>";
  
echo "<p>Contact an administrator if you have problems with the forum.</p>";
  
// select admins
$query = "SELECT * "
       . "FROM bbuser "
       . "WHERE (blocked IS NULL OR blocked = 0) "
       . "  AND admin <> 0 "
       . "ORDER BY username";
                      
$result = mysql_query ($query) 
    or Problem ("Select of admins failed: " . mysql_error ());

bTable ();

// column names

bRow ("lightblue");
  tHead ('Name');
  tHead ('Email');
eRow ();
  
while ($row = mysql_fetch_array ($result))
  {
  // row data
  shLink ($usernamelink, htmlentities ($row ['username']), 
          "bbshowbio.php", 
          "bbuser_id=" . $row ['bbuser_id']);
  if ($row ['show_email'])
      $emaillink = "<a href=\"mailto:"
                . htmlentities ($row ["email"])
                . "\">"
                . htmlentities ($row ["email"])
                . "</a>";
  else
    $emaillink = "-";
    
          
  bRow ("azure");
    tDataH ($usernamelink);
    tDataH ($emaillink);
  eRow ();
  } // end of loop


eTable ();

echo "<p></p>"; 
 

mysql_free_result ($result);


echo "<hr>\n";

// ----------------  section moderators -------------------
    
// select moderators
$query = "SELECT * "
       . "FROM bbuser, bbsection "
       . "WHERE (blocked IS NULL OR blocked = 0) "
       . "  AND moderator_section <> 0 "
       . "  AND bbsection.bbsection_id = moderator_section "
       . "  AND section_description IS NOT NULL "       
       . "ORDER BY username";
                      
$result = mysql_query ($query) 
    or Problem ("Select of moderators failed: " . mysql_error ());

  if (mysql_num_rows ($result))
    {
    echo "<h2>Forum section moderators</h2>";
      
    echo "<p>Contact a moderator if you have problems with their particular section.</p>";
    
    bTable ();
    
    // column names
    
    bRow ("lightblue");
      tHead ('Name');
      tHead ('Email');
      tHead ('Section');
    eRow ();
      
    while ($row = mysql_fetch_array ($result))
      {
      // row data
      shLink ($usernamelink, htmlentities ($row ['username']), 
              "bbshowbio.php", 
              "bbuser_id=" . $row ['bbuser_id']);
      shLink ($departmentlink, htmlentities ($row ['section_name']), 
              "bbshowpost.php", 
              "bbsection_id=" . $row ['bbsection_id']);
      if ($row ['show_email'])
          $emaillink = "<a href=\"mailto:"
                    . htmlentities ($row ["email"])
                    . "\">"
                    . htmlentities ($row ["email"])
                    . "</a>";
      else
        $emaillink = "-";
        
              
      bRow ("azure");
        tDataH ($usernamelink);
        tDataH ($emaillink);
        tDataH  ($departmentlink);
      eRow ();
      } // end of loop
    
    
    eTable ();
    
    echo "<p></p>"; 
     
    echo "<hr>\n";
    
    } // end of having section moderators
  
// ----------------  topic moderators -------------------
    
// select moderators
$query = "SELECT *, CONCAT(section_name, ':', topic_name) as department "
       . "FROM bbuser, bbtopic, bbsection "
       . "WHERE (blocked IS NULL OR blocked = 0) "
       . "  AND moderator_topic <> 0 "
       . "  AND bbtopic.bbtopic_id = moderator_topic  "       
       . "  AND bbsection.bbsection_id = bbtopic.bbsection_id " 
       . "  AND topic_description IS NOT NULL "      
       . "ORDER BY username";
                      
$result = mysql_query ($query) 
    or Problem ("Select of moderators failed: " . mysql_error ());

  if (mysql_num_rows ($result))
    {
    echo "<h2>Forum topic moderators</h2>";
      
    echo "<p>Contact a moderator if you have problems with their particular topic.</p>";
    
    bTable ();
    
    // column names
    
    bRow ("lightblue");
      tHead ('Name');
      tHead ('Email');
      tHead ('Topic');
    eRow ();
      
    while ($row = mysql_fetch_array ($result))
      {
      // row data
      shLink ($usernamelink, htmlentities ($row ['username']), 
              "bbshowbio.php", 
              "bbuser_id=" . $row ['bbuser_id']);
      shLink ($departmentlink, htmlentities ($row ['department']), 
              "bbshowpost.php", 
              "bbtopic_id=" . $row ['bbtopic_id']);
      if ($row ['show_email'])
          $emaillink = "<a href=\"mailto:"
                    . htmlentities ($row ["email"])
                    . "\">"
                    . htmlentities ($row ["email"])
                    . "</a>";
      else
        $emaillink = "-";
        
              
      bRow ("azure");
        tDataH ($usernamelink);
        tDataH ($emaillink);
        tDataH  ($departmentlink);
      eRow ();
      } // end of loop
    
    
    eTable ();
    
    echo "<p></p>"; 
     
    echo "<hr>\n";
    
    } // end of having topic moderators



mysql_free_result ($result);

hLink ("Back to " . htmlentities ($forum_name), "bbshowpost.php");
        
?>

<?php MessageTail (); ?>