# MySQL dump 8.10
#
# Host: localhost    Database: forum
#--------------------------------------------------------
# Server version	3.23.27-beta

#
# Table structure for table 'access'
#

CREATE TABLE access (
  accessid int(11) NOT NULL auto_increment,
  tablename varchar(60) DEFAULT '' NOT NULL,
  userid int(11) DEFAULT '0' NOT NULL,
  can_select tinyint(4),
  can_delete tinyint(4),
  can_insert tinyint(4),
  can_update tinyint(4),
  PRIMARY KEY (accessid)
);

#
# Dumping data for table 'access'
#

INSERT INTO access VALUES (1,'%',1,1,1,1,1);

#
# Table structure for table 'bbbanned'
#

CREATE TABLE bbbanned (
  banned_address varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY (banned_address)
);

#
# Dumping data for table 'bbbanned'
#


#
# Table structure for table 'bbnotify_subject'
#

CREATE TABLE bbnotify_subject (
  bbuser_id int(11) DEFAULT '0' NOT NULL,
  bbsubject_id int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (bbuser_id,bbsubject_id),
  KEY idx_bbsubject_id (bbsubject_id)
);

#
# Dumping data for table 'bbnotify_subject'
#


#
# Table structure for table 'bbnotify_topic'
#

CREATE TABLE bbnotify_topic (
  bbuser_id int(11) DEFAULT '0' NOT NULL,
  bbtopic_id int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (bbuser_id,bbtopic_id),
  KEY idx_bbtopic_id (bbtopic_id)
);

#
# Dumping data for table 'bbnotify_topic'
#


#
# Table structure for table 'bbpost'
#

CREATE TABLE bbpost (
  bbpost_id int(11) NOT NULL auto_increment,
  bbsubject_id int(11) DEFAULT '0' NOT NULL,
  bbuser_id int(11) DEFAULT '0' NOT NULL,
  post_text text DEFAULT '' NOT NULL,
  post_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  amend_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  html tinyint(4),
  forum_code tinyint(4),
  amended_by int(11),
  PRIMARY KEY (bbpost_id),
  KEY bbsubject_id (bbsubject_id),
  KEY bbuser_id (bbuser_id)
);

#
# Dumping data for table 'bbpost'
#

INSERT INTO bbpost VALUES (1,1,1,'[b]Who wrote the forum software?[/b]\r\n\r\nIt was written by Nick Gammon <nick@gammon.com.au>.\r\n\r\nIt was developed in Melbourne, Victoria, Australia.\r\n\r\n[b]What language is it written in?[/b]\r\n\r\nIt is written in PHP 4 (Personal Home Page version 4).\r\n\r\nPHP is at http://www.php.net/\r\n\r\n[b]What database does it use?[/b]\r\n\r\nMessages, users, topics and so on are stored on a MySQL database.\r\n\r\nMySQL is at http://www.mysql.com/\r\n\r\n[b]What platform does it run on?[/b]\r\n\r\nAt present it runs on Linux, however as PHP and MySQL both run on Windows it can probably be made to work there too.\r\n\r\n[b]Is it for sale?[/b]\r\n\r\nThe forum software is released under the GNU General Public License.\r\n\r\nYou can see a copy of that at http://www.fsf.org/copyleft/gpl.html\r\n\r\nIn essence, this means you can copy the software without paying for it. There are some restrictions imposed by the licence, you should read it for more details.\r\n\r\n[b]How do I get a copy?[/b]\r\n\r\nAt present the forum software is under development, and no public release has been made. If sufficient interest is shown then the relevant files will be packaged up and released for general use. In the first instance, contact the author: nick@gammon.com.au\r\n','2001-05-14 06:27:29','2001-05-14 06:27:29',0,1,NULL);
INSERT INTO bbpost VALUES (2,2,1,'You can send a message to another forum user, even if s/he has chosen not to disclose their email address.\r\n\r\nTo do this, view their profile by clicking on the \"bio\" link above any message, or view the list of registered users and click on their user name.\r\n\r\nUnder their profile will be a link \"Send an email to X\" where X is their name.\r\n\r\nClick on that and you can type in a message to them.\r\n\r\nIn order for that link to be shown:\r\n\r\n* You must permit mail messages [b]to yourself[/b] (so they can reply).\r\n* The user you are [b]sending to[/b] must permit mail messages.\r\n* You must have logged onto the forum so it knows who you are.\r\n\r\nTo permit sending and receiving mail messages click on the \"Edit profile\" link at the top of the page, and then check the \"allow mail\" box.\r\n\r\nAlternatively, if you have checked \"show email\" then you can also send and receive messages.\r\n\r\nIf you \"allow mail\" but [b]not[/b] \"show email\" then other people can write messages to you [b]via the forum[/b] but not directly via an email program. This is to preserve your privacy.\r\n','2001-05-14 06:28:37','2001-05-14 06:28:37',0,1,NULL);
INSERT INTO bbpost VALUES (3,3,1,'You can use \"forum codes\". \r\n\r\nOnce turned on you can use [b] for bold, [u] for underline and so on.','2001-05-14 06:29:43','2001-05-14 06:29:43',0,0,NULL);
INSERT INTO bbpost VALUES (4,4,1,'You only need to register in order to post messages. \r\n\r\nThe registration process simply ensures that we have a valid email address on file for you, so that when you request to subscribe to certain topics, the notification messages will be sent to you and not someone else. \r\n\r\nAfter registering you can optionally enter biographical information (by editing your \"profile\"), to help other users get to know you better. \r\n\r\n','2001-05-14 06:30:41','2001-05-14 06:30:41',0,0,NULL);
INSERT INTO bbpost VALUES (5,5,1,'Once you have registered you can click on the \"edit profile\" link on the top right-hand corner of the web page. \r\n\r\nThis lets you change your details. \r\n\r\nTo change your password, click on \"edit profile\" and then \"change your password\". ','2001-05-14 06:31:02','2001-05-14 06:31:02',0,0,NULL);
INSERT INTO bbpost VALUES (6,6,1,'You can view a list of users by clicking on the \"users\" link on the top right-hand corner of the web page. \r\n\r\nOnce you see the list of users you can click on anyone\'s name to see their personal profile. ','2001-05-14 06:31:55','2001-05-14 06:31:55',0,0,NULL);
INSERT INTO bbpost VALUES (7,7,1,'To search for messages about a particular subject, click on the \"search\" link on the top right-hand corner of the web page. \r\n\r\nYou can choose to search a particular topic (eg. FAQ) or all topics. \r\n\r\nThe word or phrase you type in will be searched for (exactly as written) in both the subject lines, and the body of each message.','2001-05-14 06:32:17','2001-05-14 06:32:17',0,0,NULL);
INSERT INTO bbpost VALUES (8,8,1,'[b]Subscribing to a topic[/b]\r\n\r\nAfter joining you browse the [b]major[/b] topic headings (eg. Internet, Security, whatever). You then subscribe to the [b]topic[/b]. This will then notify you by email of the first post, of a new thread, in that topic. \r\n\r\nStraight away, from the email which tells you the subject heading, you can decide if you are interested. For instance, if you got an email saying \"John Smith has posted a message about the Epson 2250 printer\", then you can decide whether to take it further. \r\n\r\nIf not, then all further posts about that printer are [b]not[/b] notified to you, thus saving your time.\r\n\r\n\r\n[b]Subscribing to a particular thread[/b]\r\n\r\nAfter reading the first message in a thread (eg. how to compile the kernel under Red Hat), if the initial message sounds interesting, then you subscribe [b]to the thread[/b], which then notifies you of each subsequent reply. \r\n\r\nNow you can read them in a timely fashion, with the messages appearing [b]in context[/b] - ie. in an orderly thread, so you can immediately see each response in relation to the points raised earlier. \r\n\r\n[b]Dynamic filter[/b]\r\n\r\nBasically you can use the forum as a sort of dynamic filter, which you control on a day-to-day basis. Since new [b]topics[/b] are likely to appear comparatively infrequently, you hopefully won\'t be subscribing every ten minutes. \r\n\r\n','2001-05-14 06:33:06','2001-05-14 06:33:06',0,1,NULL);
INSERT INTO bbpost VALUES (9,9,1,'[b]One at a time[/b]\r\n\r\nWhen viewing a particular subject, or the subject list, you will see an \"unsubscribe\" link near the bottom of the page. Click on that to unsubscribe from whatever you are looking at.\r\n\r\n[b]Viewing all your subscriptions[/b]\r\n\r\nBy viewing your \"user profile\" you will see a list of all your subscriptions. In each case there will be an \"unsubscribe\" link next to it which you can click on.\r\n\r\n[b]Unsubscribing from all[/b]\r\n\r\nIf you wish to discontinue getting [b]any[/b] notifications by email, view your user profile, and then click on \"cancel all subscriptions\".\r\n','2001-05-14 06:33:37','2001-05-14 06:33:37',0,1,NULL);
INSERT INTO bbpost VALUES (10,10,1,'Testing doing a post here.','2001-05-14 06:34:31','2001-05-14 06:34:31',0,0,NULL);
INSERT INTO bbpost VALUES (11,11,1,'<p>To make things easier for users from all around the world, the forum stores message dates internally as UTC time (Universal Coordinated Time), also known as Greenwich Mean Time (GMT).\r\n\r\n<p>Messages will be timestamped in UTC time, not with the date/time on the web server.\r\n\r\n<p>You can now adjust the way the time is displayed for you by editing your profile (click on the Edit Profile link at the top of the page), and then keying in the number of hours difference between where you live, and UTC.\r\n\r\n<p>To find the number of hours difference you can go the <a href=\"http://www.timezoneconverter.com/\">Time Zone Converter</a> web page, or choose a city from the list below that is in the same time zone that you are.\r\n\r\n<p>Here are some example time differences:\r\n\r\n<ul>  <li> 0 Dublin, Edinburgh, Lisbon, London, Monrovia, Casablanca \r\n  <li> +1 Amsterdam, Berlin, Rome, Paris, Madrid \r\n  <li> +2 Athens, Helsinki, Istanbul, Cairo, E. Europe \r\n  <li> +3 Baghdad, Kuwait, Nairobi, Moscow \r\n  <li> +4 Abu Dhabi, Kazan, Muscat \r\n  <li> +5 Islamabad, Karachi, Tashkent \r\n  <li> +6 Almaty, Dhaka \r\n  <li> +7 Bangkok, Jakarta, Hanoi \r\n  <li> +8 Beijing, Hong Kong, Perth, Singapore, Taipei\r\n  <li> +9 Tokyo, Osaka, Sapporto, Seoul, Yakutsk\r\n  <li> +10 Brisbane, Melbourne, Sydney, Guam \r\n  <li> +11 Magadan, Soloman Is., New Caledonia \r\n  <li> +12 Fiji, Kamchatka, Marshall Is., Wellington\r\n  <li> -1 Azores, Cape Verde Is.\r\n  <li> -2 Mid-Atlantic \r\n  <li> -3 Brasilia, Buenos Aires, Georgetown \r\n  <li> -4 Atlantic Time (Canada), Caracas, La Paz \r\n  <li> -5 Eastern Time (US & Canada), Indiana (East) \r\n  <li> -6 Central Time (US & Canada), Mexico city\r\n  <li> -7 Arizona, Mountain Time (US & Canada) \r\n  <li> -8 Pacific Time (US & Canada), Tijuana \r\n  <li> -9 Alaska \r\n  <li> -10 Hawaii \r\n  <li> -11 Midway Island, Samoa\r\n  <li> -12 Eniwetok, Kwajalein\r\n</ul>\r\n','2001-05-14 06:36:10','2001-05-14 06:36:10',1,0,NULL);

#
# Table structure for table 'bbsection'
#

CREATE TABLE bbsection (
  bbsection_id int(11) NOT NULL auto_increment,
  section_name varchar(60) DEFAULT '' NOT NULL,
  section_description text,
  section_motd text,
  PRIMARY KEY (bbsection_id)
);

#
# Dumping data for table 'bbsection'
#

INSERT INTO bbsection VALUES (1,'Using the forum','How to use the forum - registering, searching, FAQs and so on.',NULL);

#
# Table structure for table 'bbsubject'
#

CREATE TABLE bbsubject (
  bbsubject_id int(11) NOT NULL auto_increment,
  bbtopic_id int(11) DEFAULT '0' NOT NULL,
  subject_name varchar(255) DEFAULT '' NOT NULL,
  closed tinyint(4),
  last_post_date datetime,
  last_post_user int(11),
  count_posts int(11),
  author int(11),
  count_views int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (bbsubject_id),
  KEY bbtopic_id (bbtopic_id)
);

#
# Dumping data for table 'bbsubject'
#

INSERT INTO bbsubject VALUES (1,2,'How it was written',NULL,'2001-05-14 06:27:29',1,1,1,1);
INSERT INTO bbsubject VALUES (2,3,'Sending messages',NULL,'2001-05-14 06:28:37',1,1,1,1);
INSERT INTO bbsubject VALUES (3,4,'How do I make my message appear in bold, underline and so on?',NULL,'2001-05-14 06:29:43',1,1,1,1);
INSERT INTO bbsubject VALUES (4,5,'Why register?',NULL,'2001-05-14 06:30:41',1,1,1,1);
INSERT INTO bbsubject VALUES (5,5,'How do I change my registration details?',NULL,'2001-05-14 06:31:02',1,1,1,1);
INSERT INTO bbsubject VALUES (6,6,'Search for a user',NULL,'2001-05-14 06:31:55',1,1,1,1);
INSERT INTO bbsubject VALUES (7,6,'Search for a message',NULL,'2001-05-14 06:32:17',1,1,1,1);
INSERT INTO bbsubject VALUES (8,7,'What is subscribing?',NULL,'2001-05-14 06:33:06',1,1,1,1);
INSERT INTO bbsubject VALUES (9,7,'How do I unsubscribe?',NULL,'2001-05-14 06:33:37',1,1,1,1);
INSERT INTO bbsubject VALUES (10,8,'Test post',NULL,'2001-05-14 06:34:31',1,1,1,1);
INSERT INTO bbsubject VALUES (11,9,'Message dates are stored in UTC format',NULL,'2001-05-14 06:36:10',1,1,1,1);

#
# Table structure for table 'bbtopic'
#

CREATE TABLE bbtopic (
  bbtopic_id int(11) NOT NULL auto_increment,
  bbsection_id int(11) DEFAULT '0' NOT NULL,
  topic_name varchar(60) DEFAULT '' NOT NULL,
  admin_only tinyint(4),
  topic_description text,
  topic_motd text,
  PRIMARY KEY (bbtopic_id),
  KEY bbsection_id (bbsection_id)
);

#
# Dumping data for table 'bbtopic'
#

INSERT INTO bbtopic VALUES (0,0,'(no topic)',NULL,NULL,NULL);
update bbtopic set bbtopic_id = 0;  
INSERT INTO bbtopic VALUES (2,1,'About',0,'About the forum software itself.','');
INSERT INTO bbtopic VALUES (3,1,'Mailing other users',0,'Sending messages to other forum users.','');
INSERT INTO bbtopic VALUES (4,1,'Problems',0,'Post queries about using the forum here.','');
INSERT INTO bbtopic VALUES (5,1,'Registering',0,'Information about registering as a user of the forum.','');
INSERT INTO bbtopic VALUES (6,1,'Searching',0,'Searching for messages and other users.','');
INSERT INTO bbtopic VALUES (7,1,'Subscribing',0,'Information about subscribing to topics and subjects.','');
INSERT INTO bbtopic VALUES (8,1,'Test',0,'Use this for posting test messages, for playing with the forum software.','');
INSERT INTO bbtopic VALUES (9,1,'Time zones / time display',0,'Describes the way date/times are displayed and stored in the forum.','');

#
# Table structure for table 'bbuser'
#

CREATE TABLE bbuser (
  bbuser_id int(11) NOT NULL auto_increment,
  username varchar(30) DEFAULT '' NOT NULL,
  password varchar(20) DEFAULT '' NOT NULL,
  email varchar(255) DEFAULT '' NOT NULL,
  show_email tinyint(4),
  use_cookies tinyint(4),
  date_registered datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  date_logged_on datetime,
  date_password_mailed date,
  icq int(11),
  home_page varchar(255),
  birth_date date,
  bio text,
  signature text,
  registration_id int(11),
  admin tinyint(4),
  count_posts int(11),
  last_post_date datetime,
  country varchar(60),
  token varchar(32) DEFAULT '' NOT NULL,
  moderator_topic int(11),
  notify_add tinyint(4),
  notify_amend tinyint(4),
  notify_delete tinyint(4),
  notify_new_user tinyint(4),
  notify_amend_user tinyint(4),
  blocked tinyint(4),
  last_post_hash varchar(32),
  bounced tinyint(4),
  cookie_expiry int(11),
  last_post_subject int(11),
  moderator_section int(11),
  allow_mail tinyint(4),
  count_mail_sent int(11) DEFAULT '0' NOT NULL,
  count_mail_received int(11) DEFAULT '0' NOT NULL,
  date_mail_received datetime,
  date_mail_sent datetime,
  notify_new_thread tinyint(4),
  last_remote_ip varchar(255),
  time_zone int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (bbuser_id),
  UNIQUE idx_username (username),
  UNIQUE idx_email (email),
  UNIQUE idx_token (token)
);

#
# Dumping data for table 'bbuser'
#

INSERT INTO bbuser VALUES (1,'Forum Administrator','forumpassword','yourname@your_site.com',1,1,'2001-02-05 18:06:22','2001-05-14 06:25:37',NULL,NULL,'www.yoursite.com',NULL,'I am the administrator of this forum.','- Forum Administrator\r\n\r\nWeb: www.your_site.com\r\nEmail: yourname@your_site.com',NULL,1,11,'2001-05-14 06:36:10',NULL,'14071446d9533dd258bb146c9a19f66d',0,1,1,1,1,1,0,'7301ba5bc2fe29580bbe3b26606228af',0,31536000,11,NULL,0,1,0,NULL,'2001-03-27 19:35:18',0,'10.0.0.2',10);

#
# Table structure for table 'control'
#

CREATE TABLE control (
  item varchar(30) DEFAULT '' NOT NULL,
  contents text DEFAULT '' NOT NULL,
  id int(11) NOT NULL auto_increment,
  PRIMARY KEY (id)
);

#
# Dumping data for table 'control'
#

INSERT INTO control VALUES ('head','<html>\r\n\r\n<!-- This forum software was written by Nick Gammon -->\r\n\r\n<head>\r\n\r\n<title><%TITLE%></title>\r\n\r\n<meta name=description content=\"<%TITLE%>\">\r\n<meta name=keywords content=\"<%KEYWORDS%>\">\r\n\r\n</head>\r\n\r\n<body bgcolor=\"#F5F5F5\"\">\r\n<%FONT%>\r\n\r\n<h1>Your site name</h1>\r\n\r\n<hr>',1);
INSERT INTO control VALUES ('tail','<p>\r\nComments to: \r\n<a href=\"mailto:webmaster@your_site.com\">webmaster@your_site.com</a>\r\n</p>\r\n\r\n</font>\r\n</body>\r\n</html>',2);
INSERT INTO control VALUES ('font','<FONT FACE=\"Verdana, Arial, Helvetica, Geneva\" SIZE=-1>',3);
INSERT INTO control VALUES ('allow_deletes','1',4);
INSERT INTO control VALUES ('allow_edits','1',5);
INSERT INTO control VALUES ('allow_posts','1',6);
INSERT INTO control VALUES ('allow_registrations','1',7);
INSERT INTO control VALUES ('forum_name','Your forum name',8);
INSERT INTO control VALUES ('motd','<br>',9);
INSERT INTO control VALUES ('minuteswest','0',28);
INSERT INTO control VALUES ('users_per_page','25',29);
INSERT INTO control VALUES ('email_signature','- Administrator\r\n\r\n---------------------------------------------------------\r\nAdministrator of Your Forum.\r\n\r\nWeb:   http://www.your_site.com\r\nEmail: Your Name <yourname@your_site.com>',10);
INSERT INTO control VALUES ('email_from','Your Forum Name <forum@your_site.com>',11);
INSERT INTO control VALUES ('datetimeformat','%a %d %b %Y %h:%i %p',12);
INSERT INTO control VALUES ('dateformat','%a %d %b %Y',13);
INSERT INTO control VALUES ('timeformat','%h:%i %p',14);
INSERT INTO control VALUES ('forum_url','http://www.your_site.com/forum',15);
INSERT INTO control VALUES ('amend_post_date','0',16);
INSERT INTO control VALUES ('post_under_different_name','0',17);
INSERT INTO control VALUES ('home_url','http://www.your_site.com',18);
INSERT INTO control VALUES ('faq_url','/forum/bbshowpost.php?bbsection_id=1',19);
INSERT INTO control VALUES ('admin_links','<a href=\"/forum/\">(Forum)</a>',20);
INSERT INTO control VALUES ('recent_posts_days','14',21);
INSERT INTO control VALUES ('recent_posts_count','30',22);
INSERT INTO control VALUES ('forum_version','1',23);
INSERT INTO control VALUES ('allow_notification','1',24);
INSERT INTO control VALUES ('allow_messages','1',25);
INSERT INTO control VALUES ('posts_per_page','15',26);
INSERT INTO control VALUES ('subjects_per_page','20',27);

#
# Table structure for table 'country'
#

CREATE TABLE country (
  countryname varchar(60) DEFAULT '' NOT NULL,
  PRIMARY KEY (countryname)
);

#
# Dumping data for table 'country'
#

INSERT INTO country VALUES ('(undisclosed)');
INSERT INTO country VALUES ('Afghanistan');
INSERT INTO country VALUES ('Albania');
INSERT INTO country VALUES ('Algeria');
INSERT INTO country VALUES ('American Oceanian Territories');
INSERT INTO country VALUES ('American Samoa');
INSERT INTO country VALUES ('Andorra');
INSERT INTO country VALUES ('Angola');
INSERT INTO country VALUES ('Anguilla');
INSERT INTO country VALUES ('Antigua And Barbuda');
INSERT INTO country VALUES ('Argentina');
INSERT INTO country VALUES ('Armenia');
INSERT INTO country VALUES ('Aruba');
INSERT INTO country VALUES ('Australia');
INSERT INTO country VALUES ('Australia-Oceania');
INSERT INTO country VALUES ('Austria');
INSERT INTO country VALUES ('Azerbaijan');
INSERT INTO country VALUES ('Bahamas');
INSERT INTO country VALUES ('Bahrain');
INSERT INTO country VALUES ('Bangladesch');
INSERT INTO country VALUES ('Barbados');
INSERT INTO country VALUES ('Belarus');
INSERT INTO country VALUES ('Belgium');
INSERT INTO country VALUES ('Belize');
INSERT INTO country VALUES ('Benin');
INSERT INTO country VALUES ('Bermuda');
INSERT INTO country VALUES ('Bhutan');
INSERT INTO country VALUES ('Bolivia');
INSERT INTO country VALUES ('Bosnia And Herzegowina');
INSERT INTO country VALUES ('Botswana');
INSERT INTO country VALUES ('Brazil');
INSERT INTO country VALUES ('British Indian Ocean Territory');
INSERT INTO country VALUES ('Brunei Darussalam');
INSERT INTO country VALUES ('Bulgaria');
INSERT INTO country VALUES ('Burkina Faso');
INSERT INTO country VALUES ('Burundi');
INSERT INTO country VALUES ('Cambodia');
INSERT INTO country VALUES ('Cameroon');
INSERT INTO country VALUES ('Canada');
INSERT INTO country VALUES ('Canarian Islands');
INSERT INTO country VALUES ('Cape Verde');
INSERT INTO country VALUES ('Cayman Islands');
INSERT INTO country VALUES ('Central African Republic');
INSERT INTO country VALUES ('Ceuta');
INSERT INTO country VALUES ('Chad');
INSERT INTO country VALUES ('Chile');
INSERT INTO country VALUES ('China');
INSERT INTO country VALUES ('Colombia');
INSERT INTO country VALUES ('Comoros');
INSERT INTO country VALUES ('Congo');
INSERT INTO country VALUES ('Costa Rica');
INSERT INTO country VALUES ('Croatia');
INSERT INTO country VALUES ('Cuba');
INSERT INTO country VALUES ('Cyprus');
INSERT INTO country VALUES ('Czech Republic');
INSERT INTO country VALUES ('Denmark');
INSERT INTO country VALUES ('Djibouti');
INSERT INTO country VALUES ('Dominica');
INSERT INTO country VALUES ('Dominican Republic');
INSERT INTO country VALUES ('Ecuador');
INSERT INTO country VALUES ('Egypt');
INSERT INTO country VALUES ('El Salvador');
INSERT INTO country VALUES ('Equatorial Guinea');
INSERT INTO country VALUES ('Eritrea');
INSERT INTO country VALUES ('Estonia');
INSERT INTO country VALUES ('Ethiopia');
INSERT INTO country VALUES ('Falkland Islands');
INSERT INTO country VALUES ('Faroe Islands');
INSERT INTO country VALUES ('Fiji');
INSERT INTO country VALUES ('Finland');
INSERT INTO country VALUES ('France');
INSERT INTO country VALUES ('French Guiana');
INSERT INTO country VALUES ('French Polynesia');
INSERT INTO country VALUES ('Gabon');
INSERT INTO country VALUES ('Gambia');
INSERT INTO country VALUES ('Georgia');
INSERT INTO country VALUES ('Germany');
INSERT INTO country VALUES ('Ghana');
INSERT INTO country VALUES ('Gibraltar');
INSERT INTO country VALUES ('Greece');
INSERT INTO country VALUES ('Greenland');
INSERT INTO country VALUES ('Grenada');
INSERT INTO country VALUES ('Guadeloupe');
INSERT INTO country VALUES ('Guatemala');
INSERT INTO country VALUES ('Guinea');
INSERT INTO country VALUES ('Guinea-Bissau');
INSERT INTO country VALUES ('Guyana');
INSERT INTO country VALUES ('Haiti');
INSERT INTO country VALUES ('Honduras');
INSERT INTO country VALUES ('Hong Kong');
INSERT INTO country VALUES ('Hungary');
INSERT INTO country VALUES ('Iceland');
INSERT INTO country VALUES ('India');
INSERT INTO country VALUES ('Indonesia');
INSERT INTO country VALUES ('Iran');
INSERT INTO country VALUES ('Iraq');
INSERT INTO country VALUES ('Ireland');
INSERT INTO country VALUES ('Israel');
INSERT INTO country VALUES ('Italy');
INSERT INTO country VALUES ('Ivory Coast');
INSERT INTO country VALUES ('Jamaica');
INSERT INTO country VALUES ('Japan');
INSERT INTO country VALUES ('Jordan');
INSERT INTO country VALUES ('Kazakhstan');
INSERT INTO country VALUES ('Kenya');
INSERT INTO country VALUES ('Kirgistan');
INSERT INTO country VALUES ('Kiribati');
INSERT INTO country VALUES ('Kuwait');
INSERT INTO country VALUES ('Lao Peoples Democratic Republic');
INSERT INTO country VALUES ('Latvia');
INSERT INTO country VALUES ('Lebanon');
INSERT INTO country VALUES ('Lesotho');
INSERT INTO country VALUES ('Liberia');
INSERT INTO country VALUES ('Libyan Arab Jamahirya');
INSERT INTO country VALUES ('Liechtenstein');
INSERT INTO country VALUES ('Lithuania');
INSERT INTO country VALUES ('Luxembourg');
INSERT INTO country VALUES ('Macau');
INSERT INTO country VALUES ('Macedonia');
INSERT INTO country VALUES ('Madagascar');
INSERT INTO country VALUES ('Malawi');
INSERT INTO country VALUES ('Malaysia');
INSERT INTO country VALUES ('Maldives');
INSERT INTO country VALUES ('Mali');
INSERT INTO country VALUES ('Malta');
INSERT INTO country VALUES ('Marshall Islands');
INSERT INTO country VALUES ('Martinique');
INSERT INTO country VALUES ('Mauritania');
INSERT INTO country VALUES ('Mauritius');
INSERT INTO country VALUES ('Mayotte');
INSERT INTO country VALUES ('Mexico');
INSERT INTO country VALUES ('Micronesia');
INSERT INTO country VALUES ('Moldova');
INSERT INTO country VALUES ('Monaco');
INSERT INTO country VALUES ('Mongolia');
INSERT INTO country VALUES ('Montserrat');
INSERT INTO country VALUES ('Morocco');
INSERT INTO country VALUES ('Mozambique');
INSERT INTO country VALUES ('Myanmar');
INSERT INTO country VALUES ('Namibia');
INSERT INTO country VALUES ('Nauru');
INSERT INTO country VALUES ('Nepal');
INSERT INTO country VALUES ('Netherlands');
INSERT INTO country VALUES ('Netherlands Antilles');
INSERT INTO country VALUES ('New Caledonia');
INSERT INTO country VALUES ('New Zealand');
INSERT INTO country VALUES ('New Zealand\'s Oceania');
INSERT INTO country VALUES ('Nicaragua');
INSERT INTO country VALUES ('Niger');
INSERT INTO country VALUES ('Nigeria');
INSERT INTO country VALUES ('Northern Korea');
INSERT INTO country VALUES ('Northern Mariana Islands');
INSERT INTO country VALUES ('Norway');
INSERT INTO country VALUES ('Oman');
INSERT INTO country VALUES ('Pakistan');
INSERT INTO country VALUES ('Palau');
INSERT INTO country VALUES ('Panama');
INSERT INTO country VALUES ('Papua New Guinea');
INSERT INTO country VALUES ('Paraguay');
INSERT INTO country VALUES ('Peru');
INSERT INTO country VALUES ('Philippines');
INSERT INTO country VALUES ('Pitcairn');
INSERT INTO country VALUES ('Poland');
INSERT INTO country VALUES ('Portugal');
INSERT INTO country VALUES ('Qatar');
INSERT INTO country VALUES ('Reunion');
INSERT INTO country VALUES ('Romania');
INSERT INTO country VALUES ('Russia');
INSERT INTO country VALUES ('Rwanda');
INSERT INTO country VALUES ('San Marino');
INSERT INTO country VALUES ('Sao Tome And Principe');
INSERT INTO country VALUES ('Saudi Arabia');
INSERT INTO country VALUES ('Senegal');
INSERT INTO country VALUES ('Serbia');
INSERT INTO country VALUES ('Seychelles');
INSERT INTO country VALUES ('Sierra Leone');
INSERT INTO country VALUES ('Singapore');
INSERT INTO country VALUES ('Slovakia');
INSERT INTO country VALUES ('Slovenia');
INSERT INTO country VALUES ('Solomon Islands');
INSERT INTO country VALUES ('Somalia');
INSERT INTO country VALUES ('South Africa');
INSERT INTO country VALUES ('South Korea');
INSERT INTO country VALUES ('Spain');
INSERT INTO country VALUES ('Sri Lanka');
INSERT INTO country VALUES ('St. Helena');
INSERT INTO country VALUES ('St. Kitts');
INSERT INTO country VALUES ('St. Lucia');
INSERT INTO country VALUES ('St. Pierre And Miquelon');
INSERT INTO country VALUES ('St. Vincent');
INSERT INTO country VALUES ('Sudan');
INSERT INTO country VALUES ('Suriname');
INSERT INTO country VALUES ('Svalbard');
INSERT INTO country VALUES ('Swaziland');
INSERT INTO country VALUES ('Sweden');
INSERT INTO country VALUES ('Switzerland');
INSERT INTO country VALUES ('Syrian Arab Republic');
INSERT INTO country VALUES ('Taiwan');
INSERT INTO country VALUES ('Tajikistan');
INSERT INTO country VALUES ('Tanzania');
INSERT INTO country VALUES ('Thailand');
INSERT INTO country VALUES ('Togo');
INSERT INTO country VALUES ('Tonga');
INSERT INTO country VALUES ('Trinidad And Tobago');
INSERT INTO country VALUES ('Tueks And Caicos Islands');
INSERT INTO country VALUES ('Tunisia');
INSERT INTO country VALUES ('Turkey');
INSERT INTO country VALUES ('Turkmenistan');
INSERT INTO country VALUES ('Tuvalu');
INSERT INTO country VALUES ('Uganda');
INSERT INTO country VALUES ('UK Channel Islands');
INSERT INTO country VALUES ('Ukraine');
INSERT INTO country VALUES ('United Arab Emirates');
INSERT INTO country VALUES ('United Kingdom');
INSERT INTO country VALUES ('Uruguay');
INSERT INTO country VALUES ('USA');
INSERT INTO country VALUES ('Uzbekistan');
INSERT INTO country VALUES ('Vanuatu');
INSERT INTO country VALUES ('Vatican City State');
INSERT INTO country VALUES ('Venezuela');
INSERT INTO country VALUES ('Viet Nam');
INSERT INTO country VALUES ('Virgin Islands (British)');
INSERT INTO country VALUES ('Virgin Islands (U.S.)');
INSERT INTO country VALUES ('Wallis And Futuna Islands');
INSERT INTO country VALUES ('West Samoa');
INSERT INTO country VALUES ('Yemen');
INSERT INTO country VALUES ('Yugoslavia');
INSERT INTO country VALUES ('Zaire');
INSERT INTO country VALUES ('Zambia');
INSERT INTO country VALUES ('Zimbabwe');

#
# Table structure for table 'metarow'
#

CREATE TABLE metarow (
  metarowid int(11) NOT NULL auto_increment,
  tablename varchar(60) DEFAULT '' NOT NULL,
  columnname varchar(60) DEFAULT '' NOT NULL,
  fktable varchar(60),
  fkcolumn varchar(60),
  fkdescription varchar(255),
  validation text,
  comment text,
  password tinyint(4),
  PRIMARY KEY (metarowid),
  KEY tablename (tablename),
  UNIQUE table_column (tablename,columnname)
);

#
# Dumping data for table 'metarow'
#

INSERT INTO metarow VALUES (1,'access','userid','user','userid','username',NULL,NULL,NULL);
INSERT INTO metarow VALUES (5,'metarow','fkcolumn',NULL,NULL,NULL,'// must have fktable if we have fkcolumn\r\nif (empty ($HTTP_POST_VARS [\'fktable\'])) \r\n$error = \"Cannot have a fkcolumn without a fktable\";\r\n// must have fkdescription if we have fkcolumn\r\nelse if (empty ($HTTP_POST_VARS [\'fkdescription\'])) \r\n$error = \"fkdescription must be supplied if you have a foreign key\";','This is the field from the other table to be used in the lookup (generally the primary key field, eg. product id).',NULL);
INSERT INTO metarow VALUES (6,'metarow','fktable',NULL,NULL,NULL,'// must have fktable if we have fkcolumn\r\nif (empty ($HTTP_POST_VARS [\'fkcolumn\'])) \r\n$error = \"Cannot have a fktable without an fkcolumn \";\r\n// must have fkdescription if we have fkcolumn\r\nelse if (empty ($HTTP_POST_VARS [\'fkdescription\'])) \r\n$error = \"fkdescription must be supplied if you have a foreign key\";','If values for this field are looked up in a different table, then put the name of the other table here. (fk = Foreign Key)',NULL);
INSERT INTO metarow VALUES (7,'metarow','fkdescription',NULL,NULL,NULL,'// must have fktable if we have fkdescription\r\nif (empty ($HTTP_POST_VARS [\'fktable\'])) \r\n$error = \"Cannot have a fkdescription without an fktable\";\r\n// must have fkcolumn if we have fkdescription\r\nelse if (empty ($HTTP_POST_VARS [\'fkcolumn\'])) \r\n$error = \"fkcolumn must be supplied if you have a foreign key\";','This is the field from the other table that describes the value being looked up (eg. product name).',NULL);
INSERT INTO metarow VALUES (8,'metarow','validation',NULL,NULL,NULL,NULL,'PHP code to validate non-blank fields.\r\n\r\nThe current field is in the variable $value.\r\nYou can refer to any field other by as $HTTP_POST_VARS [\'fieldname\']. \r\n\r\nIf the validation fails then you should set $error to the reason for the failure.',NULL);
INSERT INTO metarow VALUES (11,'metarow','comment',NULL,NULL,NULL,NULL,'The comment is placed under the field data (such as this comment).',NULL);
INSERT INTO metarow VALUES (12,'metarow','password',NULL,NULL,NULL,NULL,'If non-zero, field is a password field.\r\nPasswords can be entered by preceding them with a \"=\" sign, eg. =swordfish.',NULL);
INSERT INTO metarow VALUES (14,'user','password',NULL,NULL,NULL,NULL,'Enter password for this user. Precede it with an \"=\" sign.\r\n\r\neg. =swordfish',1);
INSERT INTO metarow VALUES (27,'bbpost','bbsubject_id','bbsubject','bbsubject_id','subject_name',NULL,NULL,NULL);
INSERT INTO metarow VALUES (28,'bbpost','bbuser_id','bbuser','bbuser_id','username',NULL,NULL,NULL);
INSERT INTO metarow VALUES (26,'bbsubject','bbtopic_id','bbtopic','bbtopic_id','topic_name',NULL,NULL,NULL);
INSERT INTO metarow VALUES (25,'bbtopic','bbsection_id','bbsection','bbsection_id','section_name',NULL,NULL,NULL);
INSERT INTO metarow VALUES (29,'bbsubject','author','bbuser','bbuser_id','username',NULL,NULL,NULL);
INSERT INTO metarow VALUES (30,'bbsubject','last_post_user','bbuser','bbuser_id','username',NULL,NULL,NULL);
INSERT INTO metarow VALUES (31,'bbuser','moderator_topic','bbtopic','bbtopic_id','topic_name',NULL,'Which topic this user is the moderator of.',NULL);
INSERT INTO metarow VALUES (32,'bbpost','amended_by','bbuser','bbuser_id','username',NULL,NULL,NULL);
INSERT INTO metarow VALUES (33,'bbuser','moderator_section','bbsection','bbsection_id','section_name',NULL,'Which section this user is the moderator of.',NULL);

#
# Table structure for table 'metatable'
#

CREATE TABLE metatable (
  metatableid int(11) NOT NULL auto_increment,
  tablename varchar(60) DEFAULT '' NOT NULL,
  summaryfields varchar(255),
  summaryorder varchar(255),
  preamble text,
  beforelist text,
  beforeform text,
  postamble text,
  PRIMARY KEY (metatableid),
  UNIQUE tablename (tablename)
);

#
# Dumping data for table 'metatable'
#

INSERT INTO metatable VALUES (3,'metarow','tablename, \" - \", columnname, \" [\", metarowid, \"]\"','tablename, columnname',NULL,NULL,NULL,NULL);

#
# Table structure for table 'user'
#

CREATE TABLE user (
  userid int(11) NOT NULL auto_increment,
  username varchar(50) DEFAULT '' NOT NULL,
  password varchar(32) DEFAULT '' NOT NULL,
  executesql tinyint(4),
  amendbugs tinyint(4),
  amendclients tinyint(4),
  viewsource tinyint(4),
  edittable tinyint(4),
  session varchar(32) DEFAULT '' NOT NULL,
  cookie_expiry int(11),
  use_cookies tinyint(4),
  date_logged_on datetime,
  boilerplate tinyint(4),
  PRIMARY KEY (userid),
  KEY username (username),
  UNIQUE idx_session (session)
);

#
# Dumping data for table 'user'
#

INSERT INTO user VALUES (1,'Administrator','e3274be5c857fb42ab72d786e281b4b8',1,0,0,1,1,'2a58632eb37c74f457496ed0dad2d05b',604800,1,'2001-05-14 06:37:16',0);

